/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities.trades;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.mehvahdjukaar.moonlight.api.map.MapDecorationRegistry;
import net.mehvahdjukaar.moonlight.api.map.MapHelper;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.entities.trades.AdventurerMapTrade;
import net.mehvahdjukaar.supplementaries.common.misc.map_markers.ModMapMarkers;
import net.mehvahdjukaar.supplementaries.common.worldgen.StructureLocator;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1806;
import net.minecraft.class_1914;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_20;
import net.minecraft.class_22;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_4309;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7045;

public class AdventurerMapsHandler
extends class_4309 {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().registerTypeAdapter(AdventurerMapTrade.class, (json, typeOfT, context) -> (AdventurerMapTrade)AdventurerMapTrade.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, e -> Supplementaries.LOGGER.error("failed to parse structure map trade: {}", e))).create();
    public static final class_3302 RELOAD_INSTANCE = new AdventurerMapsHandler();
    private static final int SEARCH_RADIUS = 100;
    private static final List<AdventurerMapTrade> CUSTOM_MAPS_TRADES = new ArrayList<AdventurerMapTrade>();
    private static final Map<class_6862<class_3195>, Pair<class_2960, Integer>> DEFAULT_STRUCTURE_MARKERS = new HashMap<class_6862<class_3195>, Pair<class_2960, Integer>>();

    public AdventurerMapsHandler() {
        super(GSON, "structure_maps");
    }

    protected void apply(Map<class_2960, JsonElement> jsons, class_3300 resourceManager, class_3695 profiler) {
        CUSTOM_MAPS_TRADES.clear();
        jsons.forEach((key, json) -> {
            DataResult v = AdventurerMapTrade.CODEC.parse((DynamicOps)JsonOps.INSTANCE, json);
            AdventurerMapTrade data = (AdventurerMapTrade)v.getOrThrow(false, e -> Supplementaries.LOGGER.error("failed to parse structure map trade: {}", e));
            CUSTOM_MAPS_TRADES.add(data);
        });
        if (CUSTOM_MAPS_TRADES.size() != 0) {
            Supplementaries.LOGGER.info("Loaded  " + CUSTOM_MAPS_TRADES.size() + " structure maps trades");
        }
    }

    private static void associateStructureMarker(class_6862<class_3195> tag, class_2960 res, int color) {
        DEFAULT_STRUCTURE_MARKERS.put(tag, (Pair<class_2960, Integer>)Pair.of((Object)res, (Object)color));
    }

    private static Pair<MapDecorationType<?, ?>, Integer> getStructureMarker(class_6880<class_3195> structure) {
        class_2960 res = new class_2960("");
        int color = -1;
        for (Map.Entry<class_6862<class_3195>, Pair<class_2960, Integer>> v : DEFAULT_STRUCTURE_MARKERS.entrySet()) {
            if (!structure.method_40220(v.getKey())) continue;
            res = (class_2960)v.getValue().getFirst();
            color = (Integer)v.getValue().getSecond();
        }
        return Pair.of((Object)MapDecorationRegistry.get((class_2960)res), (Object)color);
    }

    private static Pair<MapDecorationType<?, ?>, Integer> getStructureMarker(class_6862<class_3195> tag) {
        Pair<class_2960, Integer> g = DEFAULT_STRUCTURE_MARKERS.getOrDefault(tag, (Pair<class_2960, Integer>)Pair.of((Object)new class_2960("selene:generic_structure"), (Object)-1));
        return Pair.of((Object)MapDecorationRegistry.get((class_2960)((class_2960)g.getFirst())), (Object)((Integer)g.getSecond()));
    }

    public static void addTradesCallback() {
        RegHelper.registerVillagerTrades((class_3852)class_3852.field_17054, (int)1, itemListings -> AdventurerMapsHandler.maybeAddCustomMap(itemListings, 1));
        RegHelper.registerVillagerTrades((class_3852)class_3852.field_17054, (int)2, itemListings -> {
            if (CommonConfigs.Tweaks.RANDOM_ADVENTURER_MAPS.get().booleanValue()) {
                itemListings.add(new RandomAdventureMapTrade());
            }
            AdventurerMapsHandler.maybeAddCustomMap(itemListings, 2);
        });
        RegHelper.registerVillagerTrades((class_3852)class_3852.field_17054, (int)3, itemListings -> AdventurerMapsHandler.maybeAddCustomMap(itemListings, 3));
        RegHelper.registerVillagerTrades((class_3852)class_3852.field_17054, (int)4, itemListings -> AdventurerMapsHandler.maybeAddCustomMap(itemListings, 4));
        RegHelper.registerVillagerTrades((class_3852)class_3852.field_17054, (int)5, itemListings -> AdventurerMapsHandler.maybeAddCustomMap(itemListings, 5));
    }

    private static void maybeAddCustomMap(List<class_3853.class_1652> listings, int level) {
        for (AdventurerMapTrade data : CUSTOM_MAPS_TRADES) {
            if (level != data.villagerLevel()) continue;
            listings.add(data);
        }
    }

    public static class_1799 createStructureMap(class_1937 world, class_2338 pos, class_2960 structureName, @Nullable String mapName, int mapColor, @Nullable class_2960 mapMarker) {
        class_6862 destination = class_6862.method_40092((class_5321)class_2378.field_25915, (class_2960)structureName);
        if (world instanceof class_3218) {
            class_3218 serverLevel = (class_3218)world;
            class_2338 toPos = serverLevel.method_8487(destination, pos, 100, true);
            if (toPos == null) {
                return class_1799.field_8037;
            }
            class_1799 stack = class_1806.method_8005((class_1937)world, (int)toPos.method_10263(), (int)toPos.method_10260(), (byte)2, (boolean)true, (boolean)true);
            class_1806.method_8002((class_3218)serverLevel, (class_1799)stack);
            if (structureName.method_12832().equals("ocean_monument")) {
                class_22.method_110((class_1799)stack, (class_2338)pos, (String)"+", (class_20.class_21)class_20.class_21.field_98);
            } else if (structureName.method_12832().equals("woodland_mansion")) {
                class_22.method_110((class_1799)stack, (class_2338)pos, (String)"+", (class_20.class_21)class_20.class_21.field_88);
            } else {
                int color;
                Pair<MapDecorationType<?, ?>, Integer> decoration = AdventurerMapsHandler.getStructureMarker((class_6862<class_3195>)destination);
                int n = color = mapColor == 0xFFFFFF ? (Integer)decoration.getSecond() : mapColor;
                if (mapMarker == null) {
                    MapHelper.addDecorationToMap((class_1799)stack, (class_2338)toPos, (MapDecorationType)((MapDecorationType)decoration.getFirst()), (int)color);
                } else {
                    MapHelper.addDecorationToMap((class_1799)stack, (class_2338)toPos, (class_2960)mapMarker, (int)color);
                }
            }
            class_5250 name = class_2561.method_43471((String)(mapName == null ? "filled_map." + structureName.method_12832().toLowerCase(Locale.ROOT) : mapName));
            stack.method_7977((class_2561)name);
            return stack;
        }
        return class_1799.field_8037;
    }

    static {
        AdventurerMapsHandler.associateStructureMarker((class_6862<class_3195>)class_7045.field_37047, ModMapMarkers.SHIPWRECK_TYPE, 3416079);
        AdventurerMapsHandler.associateStructureMarker(ModTags.ANCIENT_CITY, ModMapMarkers.ANCIENT_CITY_TYPE, 407920);
        AdventurerMapsHandler.associateStructureMarker(ModTags.IGLOO, ModMapMarkers.IGLOO_TYPE, 10075586);
        AdventurerMapsHandler.associateStructureMarker((class_6862<class_3195>)class_7045.field_37048, ModMapMarkers.RUINED_PORTAL_TYPE, 6238389);
        AdventurerMapsHandler.associateStructureMarker((class_6862<class_3195>)class_7045.field_37045, ModMapMarkers.VILLAGE_TYPE, 12224341);
        AdventurerMapsHandler.associateStructureMarker((class_6862<class_3195>)class_7045.field_37049, ModMapMarkers.OCEAN_RUIN_TYPE, 3828045);
        AdventurerMapsHandler.associateStructureMarker(ModTags.PILLAGER_OUTPOST, ModMapMarkers.PILLAGER_OUTPOST_TYPE, 0x1F1100);
        AdventurerMapsHandler.associateStructureMarker(ModTags.DESERT_PYRAMID, ModMapMarkers.DESERT_PYRAMID_TYPE, 8416575);
        AdventurerMapsHandler.associateStructureMarker(ModTags.JUNGLE_TEMPLE, ModMapMarkers.JUNGLE_TEMPLE_TYPE, 5400120);
        AdventurerMapsHandler.associateStructureMarker(ModTags.BASTION_REMNANT, ModMapMarkers.BASTION_TYPE, 2894127);
        AdventurerMapsHandler.associateStructureMarker(ModTags.END_CITY, ModMapMarkers.END_CITY_TYPE, 10253227);
        AdventurerMapsHandler.associateStructureMarker(ModTags.SWAMP_HUT, ModMapMarkers.SWAMP_HUT_TYPE, 1786143);
        AdventurerMapsHandler.associateStructureMarker(ModTags.NETHER_FORTRESS, ModMapMarkers.NETHER_FORTRESS, 3934219);
        AdventurerMapsHandler.associateStructureMarker((class_6862<class_3195>)class_7045.field_37046, ModMapMarkers.MINESHAFT_TYPE, 0x808080);
    }

    private static class RandomAdventureMapTrade
    implements class_3853.class_1652 {
        private RandomAdventureMapTrade() {
        }

        public class_1914 method_7246(@Nonnull class_1297 entity, @Nonnull class_5819 random) {
            int maxPrice = 13;
            int minPrice = 7;
            int price = random.method_43048(maxPrice - minPrice + 1) + minPrice;
            class_1799 itemstack = this.createMap(entity.field_6002, entity.method_24515());
            if (itemstack.method_7960()) {
                return null;
            }
            return new class_1914(new class_1799((class_1935)class_1802.field_8687, price), new class_1799((class_1935)class_1802.field_8251), itemstack, 12, 10, 0.2f);
        }

        private class_1799 createMap(class_1937 level, class_2338 pos) {
            if (level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                if (!serverLevel.method_8503().method_27728().method_28057().method_28029()) {
                    return class_1799.field_8037;
                }
                Pair<class_2338, class_6880<class_3195>> found = StructureLocator.findNearestRandomMapFeature(serverLevel, ModTags.ADVENTURE_MAP_DESTINATIONS, pos, 250, true);
                if (found != null) {
                    class_2338 toPos = (class_2338)found.getFirst();
                    class_1799 stack = class_1806.method_8005((class_1937)level, (int)toPos.method_10263(), (int)toPos.method_10260(), (byte)2, (boolean)true, (boolean)true);
                    class_1806.method_8002((class_3218)serverLevel, (class_1799)stack);
                    Pair<MapDecorationType<?, ?>, Integer> decoration = AdventurerMapsHandler.getStructureMarker((class_6880<class_3195>)((class_6880)found.getSecond()));
                    MapHelper.addDecorationToMap((class_1799)stack, (class_2338)toPos, (MapDecorationType)((MapDecorationType)decoration.getFirst()), (int)7869722);
                    stack.method_7977((class_2561)class_2561.method_43471((String)"filled_map.adventure"));
                    return stack;
                }
            }
            return class_1799.field_8037;
        }
    }
}

